//---------------------------------------------------------------------------
// Sample code for uM-FPU64 64-bit Floating Point Coprocessor
// Micromega Corporation  www.micromegacorp.com
// Author: Cam Thompson
//
// @file    test_bma1180.ino
// @target  Arduino
//
// This is a test routine for the uM-FPU64 BMA180 functions.
//
// @version
//  Aug 27, 2013
//  - original version for uM-FPU64
//---------------------------------------------------------------------------

#include <SPI.h>
#include <Fpu64.h>
#include <FpuSerial64.h>

//-------------------- uM-FPU Register Definitions -----------------------------
#define xacc              20            // uM-FPU register
#define yacc              21            // uM-FPU register
#define zacc              22            // uM-FPU register
#define temp              23            // temperature

//-------------------- uM-FPU Function Definitions -----------------------------
#define bma_init          0            // uM-FPU user function
#define bma_write_enable  1            // uM-FPU user function
#define bma_write         2            // uM-FPU user function
#define bma_read          3            // uM-FPU user function
#define bma_read_acc      4            // uM-FPU user function
#define bma_read_temp     5            // uM-FPU user function

//-------------------- setup ------------------------------------------------

void setup()
{
  Serial.begin(9600);
  Serial.println("test BMA180");
  
  SPI.begin();
  Fpu.begin();

  // Check for synchronization and display FPU version
  // (note: this is optional code)
  if (Fpu.sync() == SYNC_CHAR)
    FpuSerial.printVersionln();
  else
  {
    Serial.print("uM-FPU not detected");
    while(1) ; // stop if FPU not detected
  }
  
  delay(250);
}

//-------------------- loop -------------------------------------------------

void loop()
{
  byte cnt;

  Fpu.write(FCALL, bma_init);
  Fpu.wait();
  
  // display temperature
  Fpu.write(SELECTA, temp, FCALL, bma_read_temp, FSET0);
  Serial.print("\r\nTemperature: ");
  FpuSerial.printFloat(51);
  Serial.print(" C");
  
  // display accelerometer data
  Serial.println();
  Serial.println("Acceleration data: X, Y, Z");
  
  for (int i = 0; i < 50; i++)
  {
    Fpu.write(FCALL, bma_read_acc);
    
    Fpu.write(SELECTA, xacc);
    Fpu.write(SEROUT, 6, xacc, 0);
    FpuSerial.printFloat(0);
 
    Fpu.write(SEROUT, 8);   
    Serial.print(",");

    Fpu.write(SELECTA, yacc);
    Fpu.write(SEROUT, 6, yacc, 0);    
    FpuSerial.printFloat(0);

    Fpu.write(SEROUT, 8);    
    Serial.print(",");

    Fpu.write(SELECTA, zacc);
    Fpu.write(SEROUT, 6, zacc, 0);    
    FpuSerial.printFloat(0);
    
    Fpu.write(SEROUT, 9);   
    Serial.println();
    
    delay(100);
  }
  
  Serial.println("\r\nDone.");
  while(1) ;
}

void print_image(void)
{
  byte bval;
  Serial.print("Image registers: 0x00 to 0x3A");  
  for (int i = 0x00; i <= 0x3A; i++)
  {
    if ((i % 16) == 0) Serial.println();
    
    Fpu.write(SELECTA, 1, LSETI, i, FCALL, bma_read);
    
    Fpu.write(SELECTA, 0);     
    Fpu.wait();
    Fpu.write(SELECTA, 0, LREADBYTE);
    bval = Fpu.read();
    Serial.print(bval, HEX);
    Serial.print(", ");
  }
  Serial.println();
}

